$! (c) Alexey Chupahin  11-OCT-2007
$! Rostov-on-Don, Russia
$!
$!
$DEF SYS$ERROR _NL0:
$ SET NOON
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Configuring X11VNC for OpenVMS"
$WRITE SYS$OUTPUT " "
$! Checking architecture
$! Checking architecture
$    IF F$GETSYI("ARCH_TYPE").EQ.1 THEN CPU = "VAX"
$    IF F$GETSYI("ARCH_TYPE").EQ.2 THEN CPU = "Alpha"
$    IF F$GETSYI("ARCH_TYPE").EQ.3 THEN CPU = "I64"
$    OS = F$GETSYI("VERSION")
$WRITE SYS$OUTPUT "Checking architecture   ...  ", CPU
$WRITE SYS$OUTPUT "Checking OS             ...  OpenVMS ",OS
$SHARED=0
$IF (CPU.EQS."VAX").OR.(OS.LES."V8.2")
$  THEN
$       WRITE SYS$OUTPUT "This architecture/OS is not supported yet."
$       WRITE SYS$OUTPUT "Please contact me elvis_75@mail.ru"
$	DEAS SYS$ERROR
$       GOTO EXIT
$ENDIF
$DECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$IF (DECC) THEN $WRITE SYS$OUTPUT  "Compiler                ...  DEC C"
$IF (.NOT. DECC) 
$  THEN 
$	WRITE SYS$OUTPUT  "BAD compiler" 
$	DEAS SYS$ERROR 
$	GOTO EXIT
$ENDIF
$MMS = F$SEARCH("SYS$SYSTEM:MMS.EXE") .NES. ""
$MMK = F$TYPE(MMK)
$IF (MMS .OR. MMK.NES."") THEN GOTO TEST_LIBRARIES
$! I cant find any make tool
$WRITE SYS$OUTPUT "Please install MMS from DECSet or MMK"
$DEAS SYS$ERROR
$GOTO EXIT
$!
$!
$TEST_LIBRARIES:
$!   Setting as MAKE utility one of MMS or MMK. I prefer MMS.
$IF (MMK.NES."") THEN MAKE="MMK"
$IF (MMS) THEN MAKE="MMS"
$WRITE SYS$OUTPUT "Checking build utility  ...  ''MAKE'"
$WRITE SYS$OUTPUT " "
$!
$!
$!"Checking for correct zlib library    "
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ/INCLUDE=(ZLIB) SYS$INPUT
      #include <stdlib.h>
      #include <stdio.h>
      #include <zlib.h>
   int main()
     {
        printf("checking version zlib:  %s\n",zlibVersion());
     }
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_ZLIB=0
$	DEAS SYS$ERROR
$       GOTO EXIT
$ENDIF
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,ZLIB:LIBZ/LIB
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_ZLIB=0
$	DEAS SYS$ERROR
$       GOTO EXIT
$  ELSE
$       HAVE_ZLIB=1
$ENDIF
$IF (HAVE_ZLIB.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct zlib library ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct zlib library ...   No"
$       WRITE SYS$OUTPUT "This is fatal. Please download and install good library "
$       WRITE SYS$OUTPUT "from fafner.dyndns.org/~alexey/libsdl/public.html"
$ENDIF
$RUN TEST
$!
$! Checking for JPEG ...
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ/INCLUDE=(JPEG) SYS$INPUT
      #include <stdlib.h>
      #include <stdio.h>
      #include <jpeglib.h>
      #include <jversion.h>
   int main()
     {
        printf("checking version jpeg:  %s\n",JVERSION);
        jpeg_quality_scaling(0);
        return 0;
     }
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_JPEG=0
$       GOTO ERR1
$ENDIF
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,JPEG:LIBJPEG/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$               HAVE_JPEG=0
$  ELSE
$       HAVE_JPEG=1
$ENDIF
$!
$ERR1:
$IF (HAVE_JPEG.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct jpeg library ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct jpeg library ...   No"
$       WRITE SYS$OUTPUT "This is fatal. Please download and install good library "
$       WRITE SYS$OUTPUT "from fafner.dyndns.org/~alexey/libsdl/public.html"
$	DEAS SYS$ERROR
$       GOTO EXIT
$ENDIF
$RUN TEST
$!
$! Checking for X11 ...
$IF F$TRNLNM("DECW$INCLUDE") .NES. ""
$  THEN
$       WRITE SYS$OUTPUT "Checking for X11 ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for X11 ...   No"
$       WRITE SYS$OUTPUT "This is fatal. Please install X11 software"
$	DEAS SYS$ERROR
$       GOTO EXIT
$ENDIF
$!
$!WRITING BUILD FILES
$DEF SYS$OUTPUT _NL0:
$!
$COPY SYS$INPUT OPT.OPT
$!"Checking for snprintf    "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ SYS$INPUT
   #include <stdio.h>
   #include <stdlib.h>
   int main()
     {
        char *s=malloc(12);
        int  i = snprintf(s,(size_t)11,"%s","Hello mudo");
     }
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_SNPRINTF=0
$       GOTO NEXT4
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_SNPRINTF=0
$       GOTO NEXT4
$  ELSE
$       HAVE_SNPRINTF=1
$ENDIF
$NEXT4:
$IF (HAVE_SNPRINTF.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for snprintf ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for snprintf ...   No"
$ENDIF
$!
$!
$!
$!"Checking for vsnprintf    "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ SYS$INPUT
   #include <stdio.h>
   #include <stdlib.h>
   #include <varargs.h>
   int main()
     {
        char *s=malloc(12);
        int  i = vsnprintf(s,(size_t)11,(char*) NULL, (va_list) NULL);
     }
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_VSNPRINTF=0
$       GOTO NEXT5
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_VSNPRINTF=0
$       GOTO NEXT5
$  ELSE
$       HAVE_VSNPRINTF=1
$ENDIF
$NEXT5:
$IF (HAVE_VSNPRINTF.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   No"
$ENDIF
$!
$!
$OPEN/WRITE OUT BUILD.COM
$ WRITE OUT "$SET DEF [.LIBVNCCLIENT]"
$ WRITE OUT "$",MAKE
$ WRITE OUT "$SET DEF [-.LIBVNCSERVER]"
$ WRITE OUT "$",MAKE
$ WRITE OUT "$SET DEF [-.X11VNC]"
$ WRITE OUT "$",MAKE
$ WRITE OUT "$CURRENT = F$ENVIRONMENT (""DEFAULT"") "
$ WRITE OUT "$OPEN/WRITE OUTT [-]X11VNC$STARTUP.COM"
$ WRITE OUT "$WRITE OUTT ""$X11VNC:==$", "'","'","CURRENT'X11VNC"""
$ WRITE OUT "$SET DEF [-]"
$ WRITE OUT "$WRITE OUTT ""$IF F$SEARCH(""""BIN.DIR"""") .NES. """""""" THEN CREA/D [.BIN]"
$ WRITE OUT "$CLOSE OUTT"
$CLOSE OUT
$!
$!
$!Writing x11vnc daemon start script
$!
$!
$!
$WRITE SYS$OUTPUT "Creating [.RFB]RFBCONFIG.H"
$COPY SYS$INPUT [.RFB]RFBCONFIG.H

#ifndef _RFB_RFBCONFIG_H
#define _RFB_RFBCONFIG_H 1
 
/* Enable 24 bit per pixel in native framebuffer */
#ifndef LIBVNCSERVER_ALLOW24BPP 
#define LIBVNCSERVER_ALLOW24BPP  1 
#endif

/* work around when write() returns ENOENT but does not mean it */
/* #undef LIBVNCSERVER_ENOENT_WORKAROUND */

/* Use ffmpeg (for vnc2mpg) */
/* #undef LIBVNCSERVER_FFMPEG */

/* Define to 1 if you have the <arpa/inet.h> header file. */
#ifndef LIBVNCSERVER_HAVE_ARPA_INET_H 
#define LIBVNCSERVER_HAVE_ARPA_INET_H  1 
#endif

/* Avahi/mDNS client build environment present */
/* #undef LIBVNCSERVER_HAVE_AVAHI */

/* Define to 1 if you have the `crypt' function. */
/* #undef LIBVNCSERVER_HAVE_CRYPT */

/* Define to 1 if you have the <dlfcn.h> header file. */
/* #undef LIBVNCSERVER_HAVE_DLFCN_H */

/* Define to 1 if you don't have `vprintf' but do have `_doprnt.' */
/* #undef LIBVNCSERVER_HAVE_DOPRNT */

/* DPMS extension build environment present */
//#ifndef LIBVNCSERVER_HAVE_DPMS 
//#define LIBVNCSERVER_HAVE_DPMS  1 
//#endif

/* FBPM extension build environment present */
/* #undef LIBVNCSERVER_HAVE_FBPM */

/* Define to 1 if you have the <fcntl.h> header file. */
#ifndef LIBVNCSERVER_HAVE_FCNTL_H 
#define LIBVNCSERVER_HAVE_FCNTL_H  1 
#endif

/* Define to 1 if you have the `fork' function. */
//#ifndef LIBVNCSERVER_HAVE_FORK 
//#define LIBVNCSERVER_HAVE_FORK  1 
//#endif

/* Define to 1 if you have the `ftime' function. */
#ifndef LIBVNCSERVER_HAVE_FTIME 
#define LIBVNCSERVER_HAVE_FTIME  1 
#endif

/* Define to 1 if you have the `geteuid' function. */
#ifndef LIBVNCSERVER_HAVE_GETEUID 
#define LIBVNCSERVER_HAVE_GETEUID  1 
#endif

/* Define to 1 if you have the `gethostbyname' function. */
#ifndef LIBVNCSERVER_HAVE_GETHOSTBYNAME 
#define LIBVNCSERVER_HAVE_GETHOSTBYNAME  1 
#endif

/* Define to 1 if you have the `gethostname' function. */
#ifndef LIBVNCSERVER_HAVE_GETHOSTNAME 
#define LIBVNCSERVER_HAVE_GETHOSTNAME  1 
#endif

/* Define to 1 if you have the `getpwnam' function. */
#ifndef LIBVNCSERVER_HAVE_GETPWNAM 
#define LIBVNCSERVER_HAVE_GETPWNAM  1 
#endif

/* Define to 1 if you have the `getpwuid' function. */
#ifndef LIBVNCSERVER_HAVE_GETPWUID 
#define LIBVNCSERVER_HAVE_GETPWUID  1 
#endif

/* Define to 1 if you have the `getspnam' function. */
#ifndef LIBVNCSERVER_HAVE_GETSPNAM 
#define LIBVNCSERVER_HAVE_GETSPNAM  1 
#endif

/* Define to 1 if you have the `gettimeofday' function. */
#ifndef LIBVNCSERVER_HAVE_GETTIMEOFDAY 
#define LIBVNCSERVER_HAVE_GETTIMEOFDAY  1 
#endif

/* Define to 1 if you have the `getuid' function. */
#ifndef LIBVNCSERVER_HAVE_GETUID 
#define LIBVNCSERVER_HAVE_GETUID  1 
#endif

/* Define to 1 if you have the `grantpt' function. */
//#ifndef LIBVNCSERVER_HAVE_GRANTPT 
//#define LIBVNCSERVER_HAVE_GRANTPT  1 
//#endif

/* Define to 1 if you have the `inet_ntoa' function. */
#ifndef LIBVNCSERVER_HAVE_INET_NTOA 
#define LIBVNCSERVER_HAVE_INET_NTOA  1 
#endif

/* Define to 1 if you have the `initgroups' function. */
//#ifndef LIBVNCSERVER_HAVE_INITGROUPS 
//#define LIBVNCSERVER_HAVE_INITGROUPS  1 
//#endif

/* Define to 1 if you have the <inttypes.h> header file. */
#ifndef LIBVNCSERVER_HAVE_INTTYPES_H 
#define LIBVNCSERVER_HAVE_INTTYPES_H  1 
#endif

/* IRIX XReadDisplay available */
/* #undef LIBVNCSERVER_HAVE_IRIX_XREADDISPLAY */

/* libcrypt library present */
//#ifndef LIBVNCSERVER_HAVE_LIBCRYPT 
//#define LIBVNCSERVER_HAVE_LIBCRYPT  1 
//#endif

/* openssl libcrypto library present */
//#ifndef LIBVNCSERVER_HAVE_LIBCRYPTO 
//#define LIBVNCSERVER_HAVE_LIBCRYPTO  1 
//#endif

/* Define to 1 if you have the `cygipc' library (-lcygipc). */
/* #undef LIBVNCSERVER_HAVE_LIBCYGIPC */

/* Define to 1 if you have the `jpeg' library (-ljpeg). */
#ifndef LIBVNCSERVER_HAVE_LIBJPEG 
#define LIBVNCSERVER_HAVE_LIBJPEG  1 
#endif

/* Define to 1 if you have the `nsl' library (-lnsl). */
#ifndef LIBVNCSERVER_HAVE_LIBNSL 
#define LIBVNCSERVER_HAVE_LIBNSL  1 
#endif

/* Define to 1 if you have the `pthread' library (-lpthread). */
#ifndef LIBVNCSERVER_HAVE_LIBPTHREAD 
#define LIBVNCSERVER_HAVE_LIBPTHREAD  1 
#endif

/* Define to 1 if you have the `socket' library (-lsocket). */
/* #undef LIBVNCSERVER_HAVE_LIBSOCKET */

/* openssl libssl library present */
//#ifndef LIBVNCSERVER_HAVE_LIBSSL 
//#define LIBVNCSERVER_HAVE_LIBSSL  1 
//#endif

/* XDAMAGE extension build environment present */
/* #undef LIBVNCSERVER_HAVE_LIBXDAMAGE */

/* XFIXES extension build environment present */
/* #undef LIBVNCSERVER_HAVE_LIBXFIXES */

/* XINERAMA extension build environment present */
//#ifndef LIBVNCSERVER_HAVE_LIBXINERAMA 
//#define LIBVNCSERVER_HAVE_LIBXINERAMA  1 
//#endif

/* XRANDR extension build environment present */
//#ifndef LIBVNCSERVER_HAVE_LIBXRANDR 
//#define LIBVNCSERVER_HAVE_LIBXRANDR  1 
//#endif

/* DEC-XTRAP extension build environment present */
/* #undef LIBVNCSERVER_HAVE_LIBXTRAP */

/* Define to 1 if you have the `z' library (-lz). */
#ifndef LIBVNCSERVER_HAVE_LIBZ 
#define LIBVNCSERVER_HAVE_LIBZ  1 
#endif

/* linux fb device build environment present */
//#ifndef LIBVNCSERVER_HAVE_LINUX_FB_H 
//#define LIBVNCSERVER_HAVE_LINUX_FB_H  1 
//#endif

/* linux/input.h present */
//#ifndef LIBVNCSERVER_HAVE_LINUX_INPUT_H 
//#define LIBVNCSERVER_HAVE_LINUX_INPUT_H  1 
//#endif

/* linux uinput device build environment present */
//#ifndef LIBVNCSERVER_HAVE_LINUX_UINPUT_H 
//#define LIBVNCSERVER_HAVE_LINUX_UINPUT_H  1 
//#endif

/* video4linux build environment present */
//#ifndef LIBVNCSERVER_HAVE_LINUX_VIDEODEV_H 
//#define LIBVNCSERVER_HAVE_LINUX_VIDEODEV_H  1 
//#endif

/* build MacOS X native display support */
//#ifndef LIBVNCSERVER_HAVE_MACOSX_NATIVE_DISPLAY 
//#define LIBVNCSERVER_HAVE_MACOSX_NATIVE_DISPLAY  1 
//#endif

/* Define to 1 if you have the `memmove' function. */
#ifndef LIBVNCSERVER_HAVE_MEMMOVE 
#define LIBVNCSERVER_HAVE_MEMMOVE  1 
#endif

/* Define to 1 if you have the <memory.h> header file. */
#ifndef LIBVNCSERVER_HAVE_MEMORY_H 
#define LIBVNCSERVER_HAVE_MEMORY_H  1 
#endif

/* Define to 1 if you have the `memset' function. */
#ifndef LIBVNCSERVER_HAVE_MEMSET 
#define LIBVNCSERVER_HAVE_MEMSET  1 
#endif

/* Define to 1 if you have the `mkfifo' function. */
#ifndef LIBVNCSERVER_HAVE_MKFIFO 
#define LIBVNCSERVER_HAVE_MKFIFO  1 
#endif

/* Define to 1 if you have the `mmap' function. */
#ifndef LIBVNCSERVER_HAVE_MMAP 
#define LIBVNCSERVER_HAVE_MMAP  1 
#endif

/* Define to 1 if you have the <netdb.h> header file. */
#ifndef LIBVNCSERVER_HAVE_NETDB_H 
#define LIBVNCSERVER_HAVE_NETDB_H  1 
#endif

/* Define to 1 if you have the <netinet/in.h> header file. */
#ifndef LIBVNCSERVER_HAVE_NETINET_IN_H 
#define LIBVNCSERVER_HAVE_NETINET_IN_H  1 
#endif

/* Define to 1 if you have the <pwd.h> header file. */
#ifndef LIBVNCSERVER_HAVE_PWD_H 
#define LIBVNCSERVER_HAVE_PWD_H  1 
#endif

/* RECORD extension build environment present */
//#ifndef LIBVNCSERVER_HAVE_RECORD 
//#define LIBVNCSERVER_HAVE_RECORD  1 
//#endif

/* Define to 1 if you have the `select' function. */
#ifndef LIBVNCSERVER_HAVE_SELECT 
#define LIBVNCSERVER_HAVE_SELECT  1 
#endif

/* Define to 1 if you have the `setegid' function. */
//#ifndef LIBVNCSERVER_HAVE_SETEGID 
//#define LIBVNCSERVER_HAVE_SETEGID  1 
//#endif

/* Define to 1 if you have the `seteuid' function. */
//#ifndef LIBVNCSERVER_HAVE_SETEUID 
//#define LIBVNCSERVER_HAVE_SETEUID  1 
//#endif

/* Define to 1 if you have the `setgid' function. */
#ifndef LIBVNCSERVER_HAVE_SETGID 
#define LIBVNCSERVER_HAVE_SETGID  1 
#endif

/* Define to 1 if you have the `setpgrp' function. */
#ifndef LIBVNCSERVER_HAVE_SETPGRP 
#define LIBVNCSERVER_HAVE_SETPGRP  1 
#endif

/* Define to 1 if you have the `setsid' function. */
#ifndef LIBVNCSERVER_HAVE_SETSID 
#define LIBVNCSERVER_HAVE_SETSID  1 
#endif

/* Define to 1 if you have the `setuid' function. */
#ifndef LIBVNCSERVER_HAVE_SETUID 
#define LIBVNCSERVER_HAVE_SETUID  1 
#endif

/* Define to 1 if you have the `setutxent' function. */
//#ifndef LIBVNCSERVER_HAVE_SETUTXENT 
//#define LIBVNCSERVER_HAVE_SETUTXENT  1 
//#endif

/* Define to 1 if you have the `socket' function. */
#ifndef LIBVNCSERVER_HAVE_SOCKET 
#define LIBVNCSERVER_HAVE_SOCKET  1 
#endif

/* Solaris XReadScreen available */
/* #undef LIBVNCSERVER_HAVE_SOLARIS_XREADSCREEN */

/* Define to 1 if `stat' has the bug that it succeeds when given the
   zero-length file name argument. */
/* #undef LIBVNCSERVER_HAVE_STAT_EMPTY_STRING_BUG */

/* Define to 1 if you have the <stdint.h> header file. */
//#ifndef LIBVNCSERVER_HAVE_STDINT_H 
//#define LIBVNCSERVER_HAVE_STDINT_H  1 
//#endif

/* Define to 1 if you have the <stdlib.h> header file. */
#ifndef LIBVNCSERVER_HAVE_STDLIB_H 
#define LIBVNCSERVER_HAVE_STDLIB_H  1 
#endif

/* Define to 1 if you have the `strchr' function. */
#ifndef LIBVNCSERVER_HAVE_STRCHR 
#define LIBVNCSERVER_HAVE_STRCHR  1 
#endif

/* Define to 1 if you have the `strcspn' function. */
#ifndef LIBVNCSERVER_HAVE_STRCSPN 
#define LIBVNCSERVER_HAVE_STRCSPN  1 
#endif

/* Define to 1 if you have the `strdup' function. */
#ifndef LIBVNCSERVER_HAVE_STRDUP 
#define LIBVNCSERVER_HAVE_STRDUP  1 
#endif

/* Define to 1 if you have the `strerror' function. */
#ifndef LIBVNCSERVER_HAVE_STRERROR 
#define LIBVNCSERVER_HAVE_STRERROR  1 
#endif

/* Define to 1 if you have the `strftime' function. */
#ifndef LIBVNCSERVER_HAVE_STRFTIME 
#define LIBVNCSERVER_HAVE_STRFTIME  1 
#endif

/* Define to 1 if you have the <strings.h> header file. */
#ifndef LIBVNCSERVER_HAVE_STRINGS_H 
#define LIBVNCSERVER_HAVE_STRINGS_H  1 
#endif

/* Define to 1 if you have the <string.h> header file. */
#ifndef LIBVNCSERVER_HAVE_STRING_H 
#define LIBVNCSERVER_HAVE_STRING_H  1 
#endif

/* Define to 1 if you have the `strstr' function. */
#ifndef LIBVNCSERVER_HAVE_STRSTR 
#define LIBVNCSERVER_HAVE_STRSTR  1 
#endif

/* Define to 1 if you have the <syslog.h> header file. */
//#ifndef LIBVNCSERVER_HAVE_SYSLOG_H 
//#define LIBVNCSERVER_HAVE_SYSLOG_H  1 
//#endif

/* Use the system libvncserver build environment for x11vnc. */
/* #undef LIBVNCSERVER_HAVE_SYSTEM_LIBVNCSERVER */

/* Define to 1 if you have the <sys/ioctl.h> header file. */
#ifndef LIBVNCSERVER_HAVE_SYS_IOCTL_H 
#define LIBVNCSERVER_HAVE_SYS_IOCTL_H  1 
#endif

/* Define to 1 if you have the <sys/socket.h> header file. */
#ifndef LIBVNCSERVER_HAVE_SYS_SOCKET_H 
#define LIBVNCSERVER_HAVE_SYS_SOCKET_H  1 
#endif

/* Define to 1 if you have the <sys/stat.h> header file. */
#ifndef LIBVNCSERVER_HAVE_SYS_STAT_H 
#define LIBVNCSERVER_HAVE_SYS_STAT_H  1 
#endif

/* Define to 1 if you have the <sys/stropts.h> header file. */
//#ifndef LIBVNCSERVER_HAVE_SYS_STROPTS_H 
//#define LIBVNCSERVER_HAVE_SYS_STROPTS_H  1 
//#endif

/* Define to 1 if you have the <sys/timeb.h> header file. */
#ifndef LIBVNCSERVER_HAVE_SYS_TIMEB_H 
#define LIBVNCSERVER_HAVE_SYS_TIMEB_H  1 
#endif

/* Define to 1 if you have the <sys/time.h> header file. */
#ifndef LIBVNCSERVER_HAVE_SYS_TIME_H 
#define LIBVNCSERVER_HAVE_SYS_TIME_H  1 
#endif

/* Define to 1 if you have the <sys/types.h> header file. */
#ifndef LIBVNCSERVER_HAVE_SYS_TYPES_H 
#define LIBVNCSERVER_HAVE_SYS_TYPES_H  1 
#endif

/* Define to 1 if you have <sys/wait.h> that is POSIX.1 compatible. */
#ifndef LIBVNCSERVER_HAVE_SYS_WAIT_H 
#define LIBVNCSERVER_HAVE_SYS_WAIT_H  1 
#endif

/* Define to 1 if you have the <termios.h> header file. */
//#ifndef LIBVNCSERVER_HAVE_TERMIOS_H 
//#define LIBVNCSERVER_HAVE_TERMIOS_H  1 
//#endif

/* Define to 1 if you have the <unistd.h> header file. */
#ifndef LIBVNCSERVER_HAVE_UNISTD_H 
#define LIBVNCSERVER_HAVE_UNISTD_H  1 
#endif

/* Define to 1 if you have the <utmpx.h> header file. */
//#ifndef LIBVNCSERVER_HAVE_UTMPX_H 
//#define LIBVNCSERVER_HAVE_UTMPX_H  1 
//#endif

/* Define to 1 if you have the `vfork' function. */
#ifndef LIBVNCSERVER_HAVE_VFORK 
#define LIBVNCSERVER_HAVE_VFORK  1 
#endif

/* Define to 1 if you have the <vfork.h> header file. */
/* #undef LIBVNCSERVER_HAVE_VFORK_H */

/* Define to 1 if you have the `vprintf' function. */
#ifndef LIBVNCSERVER_HAVE_VPRINTF 
#define LIBVNCSERVER_HAVE_VPRINTF  1 
#endif

/* Define to 1 if you have the `waitpid' function. */
#ifndef LIBVNCSERVER_HAVE_WAITPID 
#define LIBVNCSERVER_HAVE_WAITPID  1 
#endif

/* Define to 1 if `fork' works. */
//#ifndef LIBVNCSERVER_HAVE_WORKING_FORK 
//#define LIBVNCSERVER_HAVE_WORKING_FORK  1 
//#endif

/* Define to 1 if `vfork' works. */
#ifndef LIBVNCSERVER_HAVE_WORKING_VFORK 
#define LIBVNCSERVER_HAVE_WORKING_VFORK  1 
#endif

/* X11 build environment present */
#ifndef LIBVNCSERVER_HAVE_X11 
#define LIBVNCSERVER_HAVE_X11  1 
#endif

/* XKEYBOARD extension build environment present */
#ifndef LIBVNCSERVER_HAVE_XKEYBOARD 
#define LIBVNCSERVER_HAVE_XKEYBOARD  1 
#endif

/* MIT-SHM extension build environment present */
#ifndef LIBVNCSERVER_HAVE_XSHM 
#define LIBVNCSERVER_HAVE_XSHM  1 
#endif

/* XTEST extension build environment present */
#ifndef LIBVNCSERVER_HAVE_XTEST 
#define LIBVNCSERVER_HAVE_XTEST  1 
#endif

/* XTEST extension has XTestGrabControl */
#ifndef LIBVNCSERVER_HAVE_XTESTGRABCONTROL 
#define LIBVNCSERVER_HAVE_XTESTGRABCONTROL  1 
#endif

/* Define to 1 if `lstat' dereferences a symlink specified with a trailing
   slash. */
//#ifndef LIBVNCSERVER_LSTAT_FOLLOWS_SLASHED_SYMLINK 
//#define LIBVNCSERVER_LSTAT_FOLLOWS_SLASHED_SYMLINK  1 
//#endif

/* Need a typedef for in_addr_t */
/* #undef LIBVNCSERVER_NEED_INADDR_T */

/* Name of package */
#ifndef LIBVNCSERVER_PACKAGE 
#define LIBVNCSERVER_PACKAGE  "x11vnc" 
#endif

/* Define to the address where bug reports for this package should be sent. */
#ifndef LIBVNCSERVER_PACKAGE_BUGREPORT 
#define LIBVNCSERVER_PACKAGE_BUGREPORT  "http://sourceforge.net/projects/libvncserver" 
#endif

/* Define to the full name of this package. */
#ifndef LIBVNCSERVER_PACKAGE_NAME 
#define LIBVNCSERVER_PACKAGE_NAME  "x11vnc" 
#endif

/* Define to the full name and version of this package. */
#ifndef LIBVNCSERVER_PACKAGE_STRING 
#define LIBVNCSERVER_PACKAGE_STRING  "x11vnc 0.9.4-VMS" 
#endif

/* Define to the one symbol short name of this package. */
#ifndef LIBVNCSERVER_PACKAGE_TARNAME 
#define LIBVNCSERVER_PACKAGE_TARNAME  "x11vnc" 
#endif

/* Define to the version of this package. */
#ifndef LIBVNCSERVER_PACKAGE_VERSION 
#define LIBVNCSERVER_PACKAGE_VERSION  "0.9.4-VMS" 
#endif

/* The number of bytes in type char */
/* #undef LIBVNCSERVER_SIZEOF_CHAR */

/* The number of bytes in type int */
/* #undef LIBVNCSERVER_SIZEOF_INT */

/* The number of bytes in type long */
/* #undef LIBVNCSERVER_SIZEOF_LONG */

/* The number of bytes in type short */
/* #undef LIBVNCSERVER_SIZEOF_SHORT */

/* The number of bytes in type void* */
/* #undef LIBVNCSERVER_SIZEOF_VOIDP */

/* Define to 1 if you have the ANSI C header files. */
#ifndef LIBVNCSERVER_STDC_HEADERS 
#define LIBVNCSERVER_STDC_HEADERS  1 
#endif

/* Define to 1 if you can safely include both <sys/time.h> and <time.h>. */
#ifndef LIBVNCSERVER_TIME_WITH_SYS_TIME 
#define LIBVNCSERVER_TIME_WITH_SYS_TIME  1 
#endif

/* Version number of package */
#ifndef LIBVNCSERVER_VERSION 
#define LIBVNCSERVER_VERSION  "0.9.4-VMS" 
#endif

/* Disable TightVNCFileTransfer protocol */
#ifndef LIBVNCSERVER_WITH_TIGHTVNC_FILETRANSFER 
#define LIBVNCSERVER_WITH_TIGHTVNC_FILETRANSFER  1 
#endif

/* Define to 1 if your processor stores words with the most significant byte
   first (like Motorola and SPARC, unlike Intel and VAX). */
/* #undef LIBVNCSERVER_WORDS_BIGENDIAN */

/* Define to 1 if the X Window System is missing or not being used. */
/* #undef LIBVNCSERVER_X_DISPLAY_MISSING */

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef const */

/* Define to `__inline__' or `__inline' if that's what the C compiler
   calls it, or to nothing if 'inline' is not supported under any name.  */
#ifndef __cplusplus
/* #undef inline */
#endif

/* Define to `int' if <sys/types.h> does not define. */
/* #undef pid_t */

/* Define to `unsigned' if <sys/types.h> does not define. */
/* #undef size_t */

/* The type for socklen */
#define socklen_t unsigned int

/* Define as `fork' if `vfork' does not work. */
/* #undef vfork */
 
/* once: _RFB_RFBCONFIG_H */
#endif

char *vms2unix( char *);
char *getpass ( const char *);
$!
$!
$IF HAVE_VSNPRINTF.EQ.1
$  THEN
$	APP SYS$INPUT  [.RFB]RFBCONFIG.H
	#define HAVE_VSNPRINTF 1
$ENDIF
$IF HAVE_VSNPRINTF.EQ.1
$  THEN
$	APP SYS$INPUT  [.RFB]RFBCONFIG.H
	#define HAVE_SNPRINTF 1
$ENDIF
$!
$!
$WRITE SYS$OUTPUT "Creating DESCRIP.MMS files"
$! Writing DESCRIP.MMS files
$COPY SYS$INPUT [.LIBVNCCLIENT]DESCRIP.MMS
# (c) Alexey Chupahin 01-OCT-2007
# OpenVMS 7.3-1, DEC 2000 mod.300
# OpenVMS 8.3,   HP rx1620

.FIRST
        DEF RFB [-.rfb]

CC=cc
CFLAGS =  /INCLUDE=([],[-],ZLIB,JPEG) /FLOAT=IEEE \
          /IEEE=DENORM /DEFINE=(HAVE_CONFIG_H) /WARN=DIS=(BADPTRARITH)\
          /OPTIMIZE=(INLINE=SPEED) \
          /DEB

OBJ=\
cursor.obj,\
listen.obj,\
minilzo.obj,\
rfbproto.obj,\
sockets.obj,\
vncviewer.obj

ALL : vncviewer.olb
        $!

vncviewer.olb : $(OBJ)
        LIB/CREA vncviewer $(OBJ)

corre.obj : corre.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

cursor.obj : cursor.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

hextile.obj : hextile.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

listen.obj : listen.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

minilzo.obj : minilzo.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

rfbproto.obj : rfbproto.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

rre.obj : rre.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sockets.obj : sockets.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tight.obj : tight.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

ultra.obj : ultra.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

vncviewer.obj : vncviewer.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

$!
$!
$COPY SYS$INPUT [.LIBVNCSERVER]DESCRIP.MMS
# (c) Alexey Chupahin 01-OCT-2007
# OpenVMS 7.3-1, DEC 2000 mod.300
# OpenVMS 8.3,   HP rx1620


.FIRST
        DEF RFB [-.rfb]

CC=cc
CFLAGS =  /INCLUDE=([],[-],ZLIB,JPEG) /FLOAT=IEEE \
          /IEEE=DENORM /DEFINE=(HAVE_CONFIG_H)\
          /OPTIMIZE=(INLINE=SPEED) \
          /DEB

OBJ=\
auth.obj,\
cargs.obj,\
corre.obj,\
cursor.obj,\
cutpaste.obj,\
d3des.obj,\
draw.obj,\
font.obj,\
hextile.obj,\
httpd.obj,\
main.obj,\
minilzo.obj,\
rfbregion.obj,\
rfbserver.obj,\
rre.obj,\
scale.obj,\
selbox.obj,\
sockets.obj,\
stats.obj,\
tight.obj,\
translate.obj,\
ultra.obj,\
vncauth.obj,\
zlib.obj,\
zrle.obj,\
zrleoutstream.obj,\
zrlepalettehelper.obj,\
vms2unix.obj,\
[.tightvnc-filetransfer]filelistinfo.obj,\
[.tightvnc-filetransfer]filetransfermsg.obj,\
[.tightvnc-filetransfer]handlefiletransferrequest.obj,\
[.tightvnc-filetransfer]rfbtightserver.obj

ALL : vncserver.olb
        $!

vncserver.olb : $(OBJ)
        LIB/CREA vncserver.olb $(OBJ)


[.tightvnc-filetransfer]filelistinfo.obj : [.tightvnc-filetransfer]filelistinfo.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.tightvnc-filetransfer]filetransfermsg.obj : [.tightvnc-filetransfer]filetransfermsg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.tightvnc-filetransfer]handlefiletransferrequest.obj : [.tightvnc-filetransfer]handlefiletransferrequest.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.tightvnc-filetransfer]rfbtightserver.obj : [.tightvnc-filetransfer]rfbtightserver.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

auth.obj : auth.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

cargs.obj : cargs.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

corre.obj : corre.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

cursor.obj : cursor.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

cutpaste.obj : cutpaste.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

d3des.obj : d3des.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

draw.obj : draw.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

font.obj : font.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

hextile.obj : hextile.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

httpd.obj : httpd.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

main.obj : main.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

minilzo.obj : minilzo.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

rfbregion.obj : rfbregion.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

rfbserver.obj : rfbserver.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

rre.obj : rre.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

scale.obj : scale.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

selbox.obj : selbox.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sockets.obj : sockets.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

stats.obj : stats.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tableinit24.obj : tableinit24.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tableinitcmtemplate.obj : tableinitcmtemplate.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tableinittctemplate.obj : tableinittctemplate.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tabletrans24template.obj : tabletrans24template.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tabletranstemplate.obj : tabletranstemplate.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tight.obj : tight.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

translate.obj : translate.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

ultra.obj : ultra.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

vncauth.obj : vncauth.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

zlib.obj : zlib.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

zrle.obj : zrle.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

zrleencodetemplate.obj : zrleencodetemplate.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

zrleoutstream.obj : zrleoutstream.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)


zrlepalettehelper.obj : zrlepalettehelper.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

vms2unix.obj : vms2unix.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)
$!
$!
$COPY SYS$INPUT [.X11VNC]DESCRIP.MMS
# (c) Alexey Chupahin 01-OCT-2007
# OpenVMS 7.3-1, DEC 2000 mod.300
# OpenVMS 8.3,   HP rx1620

.FIRST
        DEF RFB [-.rfb]

CC=cc
CFLAGS =  /INCLUDE=([],[-],ZLIB,JPEG) /FLOAT=IEEE \
          /IEEE=DENORM /DEFINE=(HAVE_CONFIG_H=1,"initialize_blackouts_and_xinerama"="init_black_and_xinerama",\
"XTestCompareCurrentCursorWithWindow_wr"="XTestCompareCurCursorWithWin_wr") /WARN=DIS=EMPTYFILE\
          /OPTIMIZE=(INLINE=SPEED) \
          /DEB


OBJ=\
8to24.obj,\
avahi.obj,\
cleanup.obj,\
connections.obj,\
cursor.obj,\
gui.obj,\
help.obj,\
inet.obj,\
keyboard.obj,\
linuxfb.obj,\
macosx.obj,\
macosxCG.obj,\
macosxCGP.obj,\
macosxCGS.obj,\
options.obj,\
pm.obj,\
pointer.obj,\
rates.obj,\
remote.obj,\
scan.obj,\
screen.obj,\
selection.obj,\
solid.obj,\
sslcmds.obj,\
sslhelper.obj,\
uinput.obj,\
unixpw.obj,\
user.obj,\
userinput.obj,\
util.obj,\
v4l.obj,\
win_utils.obj,\
x11vnc.obj,\
x11vnc_defs.obj,\
xdamage.obj,\
xevents.obj,\
xinerama.obj,\
xkb_bell.obj,\
xrandr.obj,\
xrecord.obj,\
xwrappers.obj

ALL :   x11vnc.exe
        $!

x11vnc.exe : $(OBJ)
        LINK/EXE=x11vnc $(OBJ),[-.libvncclient]vncviewer/LIB,[-.libvncserver]vncserver/LIB,JPEG:LIBJPEG/OPT,[-]OPT/OPT

8to24.obj : 8to24.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

avahi.obj : avahi.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

cleanup.obj : cleanup.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

connections.obj : connections.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

cursor.obj : cursor.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

gui.obj : gui.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

help.obj : help.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

inet.obj : inet.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

keyboard.obj : keyboard.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

linuxfb.obj : linuxfb.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

macosx.obj : macosx.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

macosxcg.obj : macosxcg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

macosxcgp.obj : macosxcgp.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

macosxcgs.obj : macosxcgs.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

options.obj : options.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

pm.obj : pm.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

pointer.obj : pointer.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

rates.obj : rates.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

remote.obj : remote.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

scan.obj : scan.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

screen.obj : screen.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

selection.obj : selection.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

solid.obj : solid.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sslcmds.obj : sslcmds.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sslhelper.obj : sslhelper.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

uinput.obj : uinput.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

unixpw.obj : unixpw.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

user.obj : user.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

userinput.obj : userinput.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

util.obj : util.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

v4l.obj : v4l.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

win_utils.obj : win_utils.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

x11vnc.obj : x11vnc.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

x11vnc_defs.obj : x11vnc_defs.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

xdamage.obj : xdamage.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

xevents.obj : xevents.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

xinerama.obj : xinerama.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

xkb_bell.obj : xkb_bell.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

xrandr.obj : xrandr.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

xrecord.obj : xrecord.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

xwrappers.obj : xwrappers.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

$!
$COPY SYS$INPUT OPT.OPT
Sys$Share:DECW$XMLibShr12.exe /Share
SYS$SHARE:DECW$XMuLibShrR5.EXE/SHARE
SYS$SHARE:DECW$XExtLibShr.EXE/SHARE
Sys$Share:DECW$XTLibShrR5.exe /Share
Sys$Share:DECW$XLibShr.exe /Share
   
$!
$!
$EXIT:
$DEL TEST.*;*
