$! (c) Alexey Chupahin  11-OCT-2007
$! Rostov-on-Don, Russia
$! elvis_75@mail.ru
$! GNU 2 or higher
$!
$!
$DEF SYS$ERROR _NL0:
$ SET NOON
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Configuring SDL_Image library"
$WRITE SYS$OUTPUT "(c) Alexey Chupahin (aka CHAPG)"
$WRITE SYS$OUTPUT " "
$! Checking architecture
$    IF F$GETSYI("ARCH_TYPE").EQ.1 THEN CPU = "VAX"
$    IF F$GETSYI("ARCH_TYPE").EQ.2 THEN CPU = "Alpha"
$    IF F$GETSYI("ARCH_TYPE").EQ.3 THEN CPU = "I64"
$    OS = F$GETSYI("VERSION")
$WRITE SYS$OUTPUT "Checking architecture   ...  ", CPU
$WRITE SYS$OUTPUT "Checking OS             ...  OpenVMS ",OS
$SHARED=0
$IF ( (CPU.EQS."Alpha").OR.(CPU.EQS."I64") )
$  THEN
$       SHARED=64
$  ELSE
$       SHARED=32
$ENDIF
$DECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$IF (DECC) THEN $WRITE SYS$OUTPUT  "Compiler		...  DEC C"
$IF (.NOT. DECC) THEN $WRITE SYS$OUTPUT  "BAD compiler" GOTO EXIT
$MMS = F$SEARCH("SYS$SYSTEM:MMS.EXE") .NES. ""
$MMK = F$TYPE(MMK) 
$IF (MMS .OR. MMK.NES."") THEN GOTO TEST_LIBRARIES
$! I cant find any make tool
$GOTO EXIT
$!
$!
$TEST_LIBRARIES:
$!   Setting as MAKE utility one of MMS or MMK. I prefer MMS.
$IF (MMS) THEN MAKE="MMS"
$IF (MMK.NES."") THEN MAKE="MMK"
$WRITE SYS$OUTPUT "Checking build utility	...  ''MAKE'"
$WRITE SYS$OUTPUT " "
$!
$!
$!"Checking for correct SDL library"
$ LIBSDL_STATIC=0
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ/INCLUDE=(SDL) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>

int main(int argc, char *argv[])
{
        SDL_version compiled;

        /* Initialize SDL */
        if ( SDL_Init(0) < 0 ) {
                fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());                exit(2);
        }
#ifdef DEBUG
        fprintf(stderr, "SDL initialized\n");
#endif
#if SDL_VERSION_ATLEAST(1, 2, 10)
#else
        printf("This version is too old. Please get newest\n");
        printf("From fafner.dyndns.org/~alexey/libsdl/public.html\n");
	exit(2);
#endif
        printf("checking version libSDL  : %d.%d.%d\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch);
        SDL_Quit();
        return(0);
}

$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_LIBSDL=0
$       GOTO NEXT0
$ENDIF
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$	LINK/EXE=TEST TEST,LIBSDL:LIBSDL/OPT
$	TMP = $STATUS
$	IF (TMP .NE. %X10000001)
$  	  THEN
$		TMP = $STATUS
$       	HAVE_LIBSDL=0
$       	GOTO NEXT0
$	  ELSE
$		LIBSDL_STATIC=1
$	ENDIF
$ENDIF
$!
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$       HAVE_LIBSDL=0
$	GOTO NEXT0
$  ELSE
$        HAVE_LIBSDL=1
$ENDIF
$NEXT0:
$IF (HAVE_LIBSDL.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   No"
$	GOTO EXIT
$ENDIF
$!
$!"Checking for TIFF library ... "
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ/INCLUDE=(TIFF) SYS$INPUT
	#include  <stdlib.h>
	#include  <strings.h>
	#include  <tiffio.h>

    int main()
	{
	if (TIFFGetVersion()==NULL) TIFFClientOpen(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
	printf("checking version libTIFF:  %s\n",TIFFGetVersion());
	}
$!
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_LIBTIFF=0
$       GOTO NEXT1
$ENDIF
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,TIFF:LIBTIFF/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_LIBTIFF=0
$       GOTO NEXT1
$ENDIF
$!
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$	HAVE_LIBTIFF=0
$  ELSE
$	 HAVE_LIBTIFF=1
$ENDIF
$NEXT1:
$IF (HAVE_LIBTIFF.EQ.1)
$  THEN
$ 	WRITE SYS$OUTPUT "Checking for correct libTIFF ...   Yes"	
$  ELSE
$	WRITE SYS$OUTPUT "Checking for correct libTIFF ...   No"
$ENDIF
$!
$!
$!"Checking for libPNG "
$! DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ/INCLUDE=(PNG,ZLIB) SYS$INPUT
	#include <stdlib.h>
        #include  <png.h>
        int main()
        {
	 png_uint_32 n,n1,n2,n3;
	 n=png_access_version_number();
	 n3=n%100; n=n/100;
	 n2=n%100; n=n/100;
	 n1=n%100; 
	if ( (n1<=1)&&(n2<2) ) 
		{ printf("checking version  libPNG:  %d.%d.%d\n",n1,n2,n3);
		  printf("This version is too old. Please get newest\n");
		  printf("From fafner.dyndns.org/~alexey/libsdl/public.html\n");
		  exit(2);
		}
	printf("checking version  libPNG:  %d.%d.%d\n",n1,n2,n3);
        }
$!
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_LIBPNG=0
$       GOTO NEXT2
$ENDIF
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,PNG:LIBPNG/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$	DEFINE SYS$OUTPUT _NLA0:
$	LINK/EXE=TEST TEST,PNG:LIBPNG/LIB,ZLIB:LIBZ/LIB
$	TMP = $STATUS
$	IF (TMP .NE. %X10000001)
$	 THEN
$       	HAVE_LIBPNG=0
$       	GOTO NEXT2
$	 ELSE
$		HAVE_LIBPNG=1
$	ENDIF
$  ELSE
$        HAVE_LIBPNG=1
$ENDIF
$!
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$	HAVE_LIBPNG=0
$  ELSE
$	HAVE_LIBPNG=1
$ENDIF
$NEXT2:
$IF (HAVE_LIBPNG.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct  libPNG ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct  libPNG ...   No"
$ENDIF
$!
$!
$!
$!"Checking for correct zlib library    "
$! DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ/INCLUDE=(ZLIB) SYS$INPUT
      #include <stdlib.h>
      #include <stdio.h>
      #include <zlib.h>
   int main()
     {
	printf("checking version zlib:  %s\n",zlibVersion());
     }
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001) 
$  THEN 
$	HAVE_ZLIB=0
$	GOTO NEXT6
$ENDIF
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,ZLIB:ZLIB/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001) 
$  THEN 
$	DEFINE SYS$OUTPUT _NLA0:
$	LINK/EXE=TEST TEST,ZLIB:LIBZ/LIB
$	TMP = $STATUS
$	DEAS  SYS$OUTPUT
$	IF (TMP .NE. %X10000001) 
$	 THEN
$		HAVE_ZLIB=0
$		GOTO NEXT6
$	 ELSE
$		HAVE_ZLIB=1
$		ZLIB_SHARED=0
$	ENDIF
$  ELSE
$	HAVE_ZLIB=1
$	ZLIB_SHARED=1
$ENDIF
$NEXT6:
$IF (HAVE_ZLIB.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct zlib library ...   Yes"
$  ELSE
$	WRITE SYS$OUTPUT "Checking for correct zlib library ...   No"
$       WRITE SYS$OUTPUT "This is fatal. Please download and install good library from fafner.dyndns.org/~alexey/libsdl/public.html"
$       GOTO EXIT
$ENDIF
$RUN TEST
$!
$! Checking for JPEG ...
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ/INCLUDE=(JPEG) SYS$INPUT
      #include <stdlib.h>
      #include <stdio.h>
      #include <jpeglib.h>
      #include <jversion.h>	
   int main()
     {
	printf("checking version jpeg:  %s\n",JVERSION);
	jpeg_quality_scaling(0);
        return 0;
     }
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$	HAVE_JPEG=0
$ENDIF
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,JPEG:LIBJPEG$SHR/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$	DEFINE SYS$OUTPUT _NLA0:
$	LINK/EXE=TEST TEST,JPEG:LIBJPEG/OPT
$	TMP = $STATUS
$	DEAS  SYS$OUTPUT
$	IF (TMP .NE. %X10000001)
$	 THEN
$		HAVE_JPEG=0
$	 ELSE
$		HAVE_JPEG=1
$	ENDIF
$	HAVE_JPEG_SHARED=0
$  ELSE
$	HAVE_JPEG_SHARED=1
$	HAVE_JPEG=1
$ENDIF
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$!
$IF (HAVE_JPEG.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct jpeg library ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct jpeg library ...   No"
$       WRITE SYS$OUTPUT "This is fatal.Please download and install good library from fafner.dyndns.org/~alexey/libsdl/public.html"
$       GOTO EXIT
$ENDIF
$RUN TEST
$IF (HAVE_JPEG_SHARED.EQ.1)
$ THEN
$	WRITE SYS$OUTPUT "Shared jpeg library found"
$ENDIF
$!
$! Checking for X11 ...
$IF F$TRNLNM("DECW$INCLUDE") .NES. ""
$  THEN
$	WRITE SYS$OUTPUT "Checking for X11 ...   Yes"
$  ELSE
$	WRITE SYS$OUTPUT "Checking for X11 ...   No"
$	WRITE SYS$OUTPUT "This is fatal. Please install X11 software"
$	GOTO EXIT
$ENDIF
$!
$!WRITING BUILD FILES
$DEF SYS$OUTPUT _NL0:
$!
$COPY SYS$INPUT TEMP.OPT
LIBSDL_IMAGE:LIBSDL_IMAGE/LIB
$!
$ IF HAVE_LIBPNG.EQ.1
$  THEN
$	APP PNG:LIBPNG.OPT TEMP.OPT
$ ENDIF
$ IF HAVE_JPEG_SHARED.EQ.1
$  THEN
$	APP JPEG:LIBJPEG$SHR.OPT TEMP.OPT
$  ELSE
$    IF HAVE_JPEG.EQ.1
$      THEN
$	  APP JPEG:LIBJPEG.OPT TEMP.OPT
$    ENDIF
$ ENDIF
$ IF (HAVE_LIBTIFF.EQ.1)
$  THEN
$	APP TIFF:LIBTIFF.OPT TEMP.OPT
$ ENDIF
$ IF (ZLIB_SHARED.EQ.0)
$  THEN
$	APP SYS$INPUT TEMP.OPT
ZLIB:LIBZ/LIB
$  ELSE
$	APP ZLIB:ZLIB.OPT TEMP.OPT
$ ENDIF
$! Removing identically library strings
$OPEN IN TEMP.OPT
$OPEN/WRI OUT LIBSDL_IMAGE.OPT
$CLOSE OUT
$READ_LOOP1:
$       READ/END=END_LOOP1 IN STR
$       OPEN OUT LIBSDL_IMAGE.OPT
$         PRESENT=0
$         READ_LOOP2:
$               READ/END=END_LOOP2 OUT STR1
$               IF STR.EQS.STR1 THEN PRESENT=1
$               GOTO READ_LOOP2
$         END_LOOP2:
$       CLOSE OUT
$       IF PRESENT.EQ.0
$        THEN
$               OPEN/APP OUT LIBSDL_IMAGE.OPT
$               WRITE OUT STR
$               CLOSE OUT
$       ENDIF
$       GOTO READ_LOOP1
$END_LOOP1:
$CLOSE IN
$
$!ENDIF
$!
$PURGE LIBSDL_IMAGE.OPT
$!
$DEAS SYS$OUTPUT
$!
$OPEN/WRITE OUT BUILD.COM
$ WRITE OUT "$",MAKE
$ WRITE OUT "$ CURRENT = F$ENVIRONMENT (""DEFAULT"") "
$ WRITE OUT "$TMP=CURRENT"
$ WRITE OUT "$OPEN/WRITE OUTT LIBSDL_IMAGE$STARTUP.COM"
$ WRITE OUT "$WRITE OUTT ""DEFINE LIBSDL_IMAGE ","'","'","TMP'""
$!
$ WRITE OUT "$WRITE SYS$OUTPUT "" ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""LIBSDL_IMAGE$STARTUP.COM has been created. ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""This file setups all logicals needed. It should be execute before using ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""Nice place to call it - LOGIN.COM ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** ""
$ IF (LIBSDL_STATIC.EQ.1)
$   THEN
$ 	WRITE OUT "$WRITE SYS$OUTPUT ""Important! You are using static library of libSDL. To compile a project with libSDL_IMAGE you should: ""
$ 	WRITE OUT "$WRITE SYS$OUTPUT ""CC/INCL=(SDL,LIBSDL_IMAGE) PROJECT.C""
$ 	WRITE OUT "$WRITE SYS$OUTPUT ""LINK PROJECT,LIBSDL_IMAGE:LIBSDL_IMAGE/OPT,LIBSDL:LIBSDL/OPT""
$   ELSE
$ 	WRITE OUT "$WRITE SYS$OUTPUT ""Important! You are using shared library of libSDL. To compile a project with libSDL_IMAGE you should: ""
$ 	WRITE OUT "$WRITE SYS$OUTPUT ""CC/INCL=(SDL,LIBSDL_IMAGE) PROJECT.C""
$ 	WRITE OUT "$WRITE SYS$OUTPUT ""LINK PROJECT,LIBSDL_IMAGE:LIBSDL_IMAGE$SHR/OPT,LIBSDL:LIBSDL$SHR/OPT""
$ENDIF
$CLOSE OUT
$!
$DEFS="LOAD_JPG, LOAD_XPM, LOAD_BMP, LOAD_GIF, LOAD_LBM, LOAD_PCX"
$IF HAVE_LIBTIFF.EQ.1 
$  THEN 
$     DEFS=DEFS+",LOAD_TIF"
$ENDIF
$IF HAVE_LIBPNG.EQ.1   
$   THEN 
$       DEFS=DEFS+",LOAD_PNG"
$ENDIF
$COP SYS$INPUT DESCRIP.MMS
# Generated by CONFIGURE.COM
# (c) Alexey Chupahin 01-OCT-2007
# OpenVMS 7.3-1, DEC 2000 mod.300
# OpenVMS 8.3,   HP rx1620
# Alexey Chupahin elvis_75@mail.ru
#

.FIRST
	DEF LIBSDL_IMAGE []


$OPEN/APPEND OUT DESCRIP.MMS
$WRITE OUT "DEFS= /DEFINE=(",DEFS,")"
$WRITE OUT ""
$CLOSE OUT
$!
$!
$APP SYS$INPUT DESCRIP.MMS
CC=cc
INCL= /INCLUDE=([],[-.include], JPEG, PNG, SDL, ZLIB, TIFF, X11)

$IF CPU.NES."VAX"
$ THEN
$	APP SYS$INPUT DESCRIP.MMS
CFLAGS = $(INCL) $(DEFS) /FLOAT=IEEE
$ ELSE
$	APP SYS$INPUT DESCRIP.MMS
CFLAGS = $(INCL) $(DEFS)
$ENDIF
$APP SYS$INPUT DESCRIP.MMS
OBJ=\
img.obj,\
img_bmp.obj,\
img_gif.obj,\
img_jpg.obj,\
img_lbm.obj,\
img_pcx.obj,\
img_png.obj,\
img_pnm.obj,\
img_tga.obj,\
img_tif.obj,\
img_xcf.obj,\
img_xpm.obj,\
img_xv.obj,\
img_xxx.obj

ALL : LIBSDL_IMAGE.OLB, SHOWIMAGE.EXE
	WRITE SYS$OUTPUT "Build process done"

img.obj : img.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_bmp.obj : img_bmp.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_gif.obj : img_gif.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_jpg.obj : img_jpg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_lbm.obj : img_lbm.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_pcx.obj : img_pcx.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_png.obj : img_png.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_pnm.obj : img_pnm.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_tga.obj : img_tga.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_tif.obj : img_tif.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_xcf.obj : img_xcf.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_xpm.obj : img_xpm.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_xv.obj : img_xv.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

img_xxx.obj : img_xxx.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)
 
showimage.obj : showimage.c
        CC $(CFLAGS) showimage.c

LIBSDL_IMAGE.OLB : $(OBJ)
        lib/crea []LIBSDL_IMAGE.OLB $(OBJ)

$IF LIBSDL_STATIC.EQ.1
$ THEN
	$APP SYS$INPUT DESCRIP.MMS
SHOWIMAGE.EXE : showimage.obj, LIBSDL_IMAGE.OLB
        LINK showimage.obj, []LIBSDL_IMAGE/OPT,LIBSDL:LIBSDL/opt
$ ELSE
$	APP SYS$INPUT DESCRIP.MMS
SHOWIMAGE.EXE : showimage.obj, LIBSDL_IMAGE.OLB, SDL_IMAGE$SHR.EXE
        LINK showimage.obj, []LIBSDL_IMAGE$SHR/OPT,LIBSDL:LIBSDL$SHR/opt

SDL_IMAGE$SHR.EXE : LIBSDL_IMAGE.OLB
 	LINK/SHARE=SDL_IMAGE$SHR.EXE []IMG,[]LIBSDL_IMAGE/OPT, LIBSDL:LIBSDL$SHR/OPT, []LIBSDL_IMAGE$DEF/OPT
	COPY SDL_IMAGE$SHR.EXE SYS$SHARE
$ENDIF

$APP SYS$INPUT DESCRIP.MMS

CLEAN :
	DEL [...]*.OBJ;*
	DEL [...]*.OLB;*
	DEL [...]*.EXE;*
$!DEL TMP.MMS;*
$!
$!
$WRITE SYS$OUTPUT "generating LIBSDL_IMAGE$SHR.OPT"
$DEF SYS$OUTPUT _NL0:
$COPY SYS$INPUT TEMP.OPT
SYS$SHARE:SDL_IMAGE$SHR/SHARE
$!
$ IF HAVE_LIBPNG.EQ.1
$  THEN
$	APP PNG:LIBPNG.OPT TEMP.OPT
$ ENDIF
$ IF HAVE_JPEG_SHARED.EQ.1
$  THEN
$	APP JPEG:LIBJPEG$SHR.OPT TEMP.OPT
$  ELSE
$    IF HAVE_JPEG.EQ.1
$      THEN
$	  APP JPEG:LIBJPEG.OPT TEMP.OPT
$    ENDIF
$ ENDIF
$ IF (HAVE_LIBTIFF.EQ.1)
$  THEN
$	APP TIFF:LIBTIFF.OPT TEMP.OPT
$ ENDIF
$ IF (ZLIB_SHARED.EQ.0)
$  THEN
$	APP SYS$INPUT TEMP.OPT
ZLIB:LIBZ/LIB
$  ELSE
$	APP ZLIB:ZLIB.OPT TEMP.OPT
$ ENDIF
$! Removing identically library strings
$OPEN IN TEMP.OPT
$OPEN/WRI OUT LIBSDL_IMAGE$SHR.OPT
$CLOSE OUT
$READ_LOOP3:
$       READ/END=END_LOOP3 IN STR
$       OPEN OUT LIBSDL_IMAGE$SHR.OPT
$         PRESENT=0
$         READ_LOOP4:
$               READ/END=END_LOOP4 OUT STR1
$               IF STR.EQS.STR1 THEN PRESENT=1
$               GOTO READ_LOOP4
$         END_LOOP4:
$       CLOSE OUT
$       IF PRESENT.EQ.0
$        THEN
$               OPEN/APP OUT LIBSDL_IMAGE$SHR.OPT
$               WRITE OUT STR
$               CLOSE OUT
$       ENDIF
$       GOTO READ_LOOP3
$END_LOOP3:
$CLOSE IN
$DEL TEMP.OPT;*
$!
$DEAS SYS$OUTPUT
$WRITE SYS$OUTPUT "generating LIBSDL_IMAGE$DEF.OPT"
$IF (SHARED.EQ.64)
$  THEN
$	COPY SYS$INPUT LIBSDL_IMAGE$DEF.OPT
SYMBOL_VECTOR= (-
IMG_Linked_Version=PROCEDURE,-
IMG_LoadTyped_RW=PROCEDURE,-
IMG_Load=PROCEDURE,-
IMG_Load_RW=PROCEDURE,-
IMG_InvertAlpha=PROCEDURE,-
IMG_isBMP=PROCEDURE,-
IMG_isGIF=PROCEDURE,-
IMG_isJPG=PROCEDURE,-
IMG_isLBM=PROCEDURE,-
IMG_isPCX=PROCEDURE,-
IMG_isPNG=PROCEDURE,-
IMG_isPNM=PROCEDURE,-
IMG_isTIF=PROCEDURE,-
IMG_isXCF=PROCEDURE,-
IMG_isXPM=PROCEDURE,-
IMG_isXV=PROCEDURE,-
IMG_LoadBMP_RW=PROCEDURE,-
IMG_LoadGIF_RW=PROCEDURE,-
IMG_LoadJPG_RW=PROCEDURE,-
IMG_LoadLBM_RW=PROCEDURE,-
IMG_LoadPCX_RW=PROCEDURE,-
IMG_LoadPNG_RW=PROCEDURE,-
IMG_LoadPNM_RW=PROCEDURE,-
IMG_LoadTGA_RW=PROCEDURE,-
IMG_LoadTIF_RW=PROCEDURE,-
IMG_LoadXCF_RW=PROCEDURE,-
IMG_LoadXPM_RW=PROCEDURE,-
IMG_LoadXV_RW=PROCEDURE,-
IMG_ReadXPMFromArray=PROCEDURE-
)
$  ELSE
$	COPY SYS$INPUT LIBSDL_IMAGE$DEF.OPT
UNIVERSAL=IMG_Linked_Version
UNIVERSAL=IMG_LoadTyped_RW
UNIVERSAL=IMG_Load
UNIVERSAL=IMG_Load_RW
UNIVERSAL=IMG_InvertAlpha
UNIVERSAL=IMG_isBMP
UNIVERSAL=IMG_isGIF
UNIVERSAL=IMG_isJPG
UNIVERSAL=IMG_isLBM
UNIVERSAL=IMG_isPCX
UNIVERSAL=IMG_isPNG
UNIVERSAL=IMG_isPNM
UNIVERSAL=IMG_isTIF
UNIVERSAL=IMG_isXCF
UNIVERSAL=IMG_isXPM
UNIVERSAL=IMG_isXV
UNIVERSAL=IMG_LoadBMP_RW
UNIVERSAL=IMG_LoadGIF_RW
UNIVERSAL=IMG_LoadJPG_RW
UNIVERSAL=IMG_LoadLBM_RW
UNIVERSAL=IMG_LoadPCX_RW
UNIVERSAL=IMG_LoadPNG_RW
UNIVERSAL=IMG_LoadPNM_RW
UNIVERSAL=IMG_LoadTGA_RW
UNIVERSAL=IMG_LoadTIF_RW
UNIVERSAL=IMG_LoadXCF_RW
UNIVERSAL=IMG_LoadXPM_RW
UNIVERSAL=IMG_LoadXV_RW
UNIVERSAL=IMG_ReadXPMFromArray
$ENDIF
$!
$!
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Now you can type @BUILD "
$!
$EXIT:
$DEFINE SYS$OUTPUT _NLA0:
$DEL TEST.OBJ;*
$DEL TEST.C;*
$DEL TEST.EXE;*
$DEAS SYS$OUTPUT
