$! (c) Alexey Chupahin  12-NOV-2007
$! GNU
$!
$!
$ SET NOON
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Configuring SDL_Net library"
$WRITE SYS$OUTPUT "(c) Alexey Chupahin (aka CHAPG) "
$WRITE SYS$OUTPUT " "
$! Checking architecture
$DECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$    IF F$GETSYI("ARCH_TYPE").EQ.1 THEN CPU = "VAX"
$    IF F$GETSYI("ARCH_TYPE").EQ.2 THEN CPU = "Alpha"
$    IF F$GETSYI("ARCH_TYPE").EQ.3 THEN CPU = "I64"
$    OS = F$GETSYI("VERSION")
$WRITE SYS$OUTPUT "Checking architecture   ...  ", CPU
$WRITE SYS$OUTPUT "Checking OS             ...  OpenVMS ",OS
$SHARED=0
$IF ( (CPU.EQS."Alpha").OR.(CPU.EQS."I64") )
$  THEN
$       SHARED=64
$  ELSE
$       SHARED=32
$ENDIF
$!
$IF (DECC) THEN $WRITE SYS$OUTPUT  "Compiler		...  DEC C"
$IF (.NOT. DECC) THEN $WRITE SYS$OUTPUT  "BAD compiler" GOTO EXIT
$MMS = F$SEARCH("SYS$SYSTEM:MMS.EXE") .NES. ""
$MMK = F$TYPE(MMK) 
$IF (MMS .OR. MMK.NES."") THEN GOTO TEST_LIBRARIES
$! I cant find any make tool
$GOTO EXIT
$!
$!
$TEST_LIBRARIES:
$!   Setting as MAKE utility one of MMS or MMK. I prefer MMS.
$IF (MMK.NES."") THEN MAKE="MMK"
$IF (MMS) THEN MAKE="MMS"
$WRITE SYS$OUTPUT "Checking build utility	...  ''MAKE'"
$WRITE SYS$OUTPUT " "
$!
$!
$!"Checking for correct SDL library"
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ LIBSDL_STATIC=0
$ CC/OBJECT=TEST.OBJ/INCLUDE=(SDL) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>

int main(int argc, char *argv[])
{
        SDL_version compiled;

        /* Initialize SDL */
        if ( SDL_Init(0) < 0 ) {
                fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());                exit(2);
        }
#ifdef DEBUG
        fprintf(stderr, "SDL initialized\n");
#endif
#if SDL_VERSION_ATLEAST(1, 2, 11)
#else
        printf("This version is too old. Please get newest\n");
        printf("From fafner.dyndns.org/~alexey/libsdl/public.html\n");
	exit(2);
#endif
        printf("checking version libSDL  : %d.%d.%d\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch);
        SDL_Quit();
        return(0);
}

$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_LIBSDL=0
$       GOTO NEXT0
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$       LINK/EXE=TEST TEST,LIBSDL:LIBSDL/OPT
$       TMP = $STATUS
$       IF (TMP .NE. %X10000001)
$         THEN
$               TMP = $STATUS
$               HAVE_LIBSDL=0
$               GOTO NEXT0
$         ELSE
$               LIBSDL_STATIC=1
$       ENDIF
$ENDIF
$!
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$       HAVE_LIBSDL=0
$	GOTO NEXT0
$  ELSE
$        HAVE_LIBSDL=1
$ENDIF
$DEAS  SYS$ERROR
$NEXT0:
$IF (HAVE_LIBSDL.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   No"
$	GOTO EXIT
$ENDIF
$!
$!"Checking for TCPIP Services ... "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/OBJECT=TEST.OBJ SYS$INPUT
	#include  <netinet/in.h>
	#include  <netinet/tcp.h>
	#include  <sys/socket.h>

    int main()
	{
	}
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_TCPIP=0
$       GOTO NEXT1
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_TCPIP=0
$       GOTO NEXT1
$ENDIF
$!
$DEFINE SYS$ERROR _NLA0:
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$	HAVE_TCPIP=0
$  ELSE
$	 HAVE_TCPIP=1
$ENDIF
$DEAS  SYS$ERROR
$NEXT1:
$IF (HAVE_TCPIP.EQ.1)
$  THEN
$ 	WRITE SYS$OUTPUT "Checking for TCPIP ...   Yes"	
$  ELSE
$	WRITE SYS$OUTPUT "Checking for TCPIP ...   No"
$ENDIF
$!
$!
$OPEN/WRITE OUT LIBSDL_NET.OPT
$ WRITE OUT "LIBSDL_NET:LIBSDL_NET/LIB"
$CLOSE  OUT
$!Append OPT files to LIBSDL_NET.OPT
$!
$OPEN/WRITE OUT BUILD.COM
$ WRITE OUT "$",MAKE
$ WRITE OUT "$ CURRENT = F$ENVIRONMENT (""DEFAULT"") "
$ WRITE OUT "$TMP=CURRENT"
$ WRITE OUT "$OPEN/WRITE OUTT LIBSDL_NET$STARTUP.COM"
$ WRITE OUT "$WRITE OUTT ""DEFINE LIBSDL_NET ","'","'","TMP'""
$!
$ WRITE OUT "$WRITE SYS$OUTPUT "" ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""LIBSDL_NET$STARTUP.COM has been created. ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""This file setups all logicals needed. It should be execute before using ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""Nice place to call it - LOGIN.COM ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** ""
$ IF (LIBSDL_STATIC.EQ.1)
$   THEN
$       WRITE OUT "$WRITE SYS$OUTPUT ""Important! You are using static library of libSDL. To compile a project with libSDL_NET you should: ""
$       WRITE OUT "$WRITE SYS$OUTPUT ""CC/INCL=(SDL,LIBSDL_NET) PROJECT.C""
$       WRITE OUT "$WRITE SYS$OUTPUT ""LINK PROJECT,LIBSDL_NET:LIBSDL_NET/OPT,LIBSDL:LIBSDL/OPT""
$   ELSE
$       WRITE OUT "$WRITE SYS$OUTPUT ""Important! You are using shared library of libSDL. To compile a project with libSDL_NET you should: ""
$       WRITE OUT "$WRITE SYS$OUTPUT ""CC/INCL=(SDL,LIBSDL_NET) PROJECT.C""
$       WRITE OUT "$WRITE SYS$OUTPUT ""LINK PROJECT,LIBSDL_NET:LIBSDL_NET$SHR/OPT,LIBSDL:LIBSDL$SHR/OPT"""
$ENDIF
$CLOSE OUT
$!
$COP SYS$INPUT DESCRIP.MMS
# Generated by CONFIGURE.COM

.FIRST
	DEF LIBSDL_NET []
 
CC=cc

CFLAGS = /INCLUDE=([],[-.include], SDL) 

OBJ = chatd.obj, SDLnet.obj,  SDLnetTCP.obj, SDLnetUDP.obj,  SDLnetselect.obj

ALL : LIBSDL_NET.OLB, CHATD.EXE
	write sys$output "Compilation process is done"


#CHAT.OBJ : CHAT.CPP
#        CXX/NOWARN $(CFLAGS) CHAT.CPP

#CHAT.EXE : CHAT.OBJ
#        CXXLNK CHAT, GUI:LIBGUI/LIB,LIBSDL_NET/LIB, LIBSDL:LIBSDL/OPT
$!
$IF (LIBSDL_STATIC.EQ.1)
$  THEN
$	APP SYS$INPUT DESCRIP.MMS

CHATD.EXE : CHATD.OBJ
        LINK CHATD, []LIBSDL_NET/LIB, LIBSDL:LIBSDL/OPT
$!
$  ELSE
$	APP SYS$INPUT DESCRIP.MMS
CHATD.EXE : CHATD.OBJ, SDL_NET$SHR.EXE
        LINK CHATD, []LIBSDL_NET$SHR/OPT, LIBSDL:LIBSDL$SHR/OPT
   
SDL_NET$SHR.EXE : LIBSDL_NET.OLB
	LINK/SHARE=SDL_NET$SHR.EXE []SDLNET,[]LIBSDL_NET/OPT, LIBSDL:LIBSDL$SHR/OPT, []LIBSDL_NET$DEF/OPT
        COPY SDL_NET$SHR.EXE SYS$SHARE
$ENDIF
$!
$ APP SYS$INPUT DESCRIP.MMS
LIBSDL_NET.OLB : $(OBJ)
        lib/crea []LIBSDL_NET.OLB SDLnet.OBJ, SDLnetTCP.OBJ, SDLnetUDP.OBJ,  SDLnetselect.OBJ

chatd.obj : chatd.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

SDLnet.obj : SDLnet.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

SDLnetTCP.obj : SDLnetTCP.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

SDLnetUDP.obj : SDLnetUDP.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

SDLnetselect.obj : SDLnetselect.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)


$!
$!
$DEAS SYS$OUTPUT
$IF (LIBSDL_STATIC.NE.1)
$  THEN
$	WRITE SYS$OUTPUT "generating LIBSDL_NET$SHR.OPT"
$	COPY SYS$INPUT LIBSDL_NET$SHR.OPT
SYS$SHARE:SDL_NET$SHR/SHARE
$ENDIF
$WRITE SYS$OUTPUT "generating LIBSDL_NET.OPT"
$COPY SYS$INPUT LIBSDL_NET.OPT
LIBSDL_NET:LIBSDL_NET/LIB
$!
$WRITE SYS$OUTPUT "generating LIBSDL_NET$DEF.OPT"
$IF (SHARED.EQ.64)
$  THEN
$       COPY SYS$INPUT LIBSDL_NET$DEF.OPT
SYMBOL_VECTOR= (-
SDLNet_Linked_Version=PROCEDURE,-
SDLNet_Init=PROCEDURE,-
SDLNet_Quit=PROCEDURE,-
SDLNet_ResolveHost=PROCEDURE,-
SDLNet_ResolveIP=PROCEDURE,-
SDLNet_TCP_Open=PROCEDURE,-
SDLNet_TCP_Accept=PROCEDURE,-
SDLNet_TCP_GetPeerAddress=PROCEDURE,-
SDLNet_TCP_Send=PROCEDURE,-
SDLNet_TCP_Recv=PROCEDURE,-
SDLNet_TCP_Close=PROCEDURE,-
SDLNet_AllocPacket=PROCEDURE,-
SDLNet_ResizePacket=PROCEDURE,-
SDLNet_FreePacket=PROCEDURE,-
SDLNet_AllocPacketV=PROCEDURE,-
SDLNet_FreePacketV=PROCEDURE,-
SDLNet_UDP_Open=PROCEDURE,-
SDLNet_UDP_Bind=PROCEDURE,-
SDLNet_UDP_Unbind=PROCEDURE,-
SDLNet_UDP_GetPeerAddress=PROCEDURE,-
SDLNet_UDP_SendV=PROCEDURE,-
SDLNet_UDP_Send=PROCEDURE,-
SDLNet_UDP_RecvV=PROCEDURE,-
SDLNet_UDP_Recv=PROCEDURE,-
SDLNet_UDP_Close=PROCEDURE,-
SDLNet_AllocSocketSet=PROCEDURE,-
SDLNet_AddSocket=PROCEDURE,-
SDLNet_DelSocket=PROCEDURE,-
SDLNet_CheckSockets=PROCEDURE,-
SDLNet_FreeSocketSet=PROCEDURE,-
SDLNet_Write16=PROCEDURE,-
SDLNet_Write32=PROCEDURE,-
SDLNet_Read16=PROCEDURE,-
SDLNet_Read32=PROCEDURE-
)
$  ELSE
$	COPY SYS$INPUT LIBSDL_NET$DEF.OPT
UNIVERSAL=SDLNet_Linked_Version
UNIVERSAL=SDLNet_Init
UNIVERSAL=SDLNet_Quit
UNIVERSAL=SDLNet_ResolveHost
UNIVERSAL=SDLNet_ResolveIP
UNIVERSAL=SDLNet_TCP_Open
UNIVERSAL=SDLNet_TCP_Accept
UNIVERSAL=SDLNet_TCP_GetPeerAddress
UNIVERSAL=SDLNet_TCP_Send
UNIVERSAL=SDLNet_TCP_Recv
UNIVERSAL=SDLNet_TCP_Close
UNIVERSAL=SDLNet_AllocPacket
UNIVERSAL=SDLNet_ResizePacket
UNIVERSAL=SDLNet_FreePacket
UNIVERSAL=SDLNet_AllocPacketV
UNIVERSAL=SDLNet_FreePacketV
UNIVERSAL=SDLNet_UDP_Open
UNIVERSAL=SDLNet_UDP_Bind
UNIVERSAL=SDLNet_UDP_Unbind
UNIVERSAL=SDLNet_UDP_GetPeerAddress
UNIVERSAL=SDLNet_UDP_SendV
UNIVERSAL=SDLNet_UDP_Send
UNIVERSAL=SDLNet_UDP_RecvV
UNIVERSAL=SDLNet_UDP_Recv
UNIVERSAL=SDLNet_UDP_Close
UNIVERSAL=SDLNet_AllocSocketSet
UNIVERSAL=SDLNet_AddSocket
UNIVERSAL=SDLNet_DelSocket
UNIVERSAL=SDLNet_CheckSockets
UNIVERSAL=SDLNet_FreeSocketSet
UNIVERSAL=SDLNet_Write16
UNIVERSAL=SDLNet_Write32
UNIVERSAL=SDLNet_Read16
UNIVERSAL=SDLNet_Read32

$ENDIF
$!
$!
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Now you can type @BUILD "
$!
$EXIT:
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$DEL TEST.OBJ;*
$DEL TEST.C;*
$DEL TEST.EXE;*
$DEAS SYS$ERROR
$DEAS SYS$OUTPUT
